import { Injectable } from '@angular/core';
import { AngularFireAuth } from '@angular/fire/compat/auth';
import { Router } from '@angular/router';
import { from, tap } from 'rxjs';
import { RegisterUser } from './models/register-user.model';
import { UserCredentials } from './models/user-credentials.model';

@Injectable({
  providedIn: 'root'
})
export class AuthService {

  private _isAuth!: boolean;
  get isAuth() {
    return this._isAuth;
  }

  constructor(
    private readonly afAuthService: AngularFireAuth,
    private readonly router: Router) {
    this.subscribeToAuthChanges();
  }

  register(user: RegisterUser) {
    return from(this.afAuthService.createUserWithEmailAndPassword(user.email, user.password))
      .pipe(
        (tap(() => { this.redirect() })));
  }

  login(credentials: UserCredentials) {
    return from(this.afAuthService.signInWithEmailAndPassword(credentials.email, credentials.password))
      .pipe((
        tap(() => { this.redirect() })));
  }

  logout() {
    return from(this.afAuthService.signOut());
  }

  private subscribeToAuthChanges() {
    this.afAuthService.user.subscribe((user) => {
      this._isAuth = user ? true : false;
    })
  }

  private redirect() {
    this.router.navigate(['restaurants']);
  }
}
